package gov.va.med.mhv.login.hook;

import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.login.hook.SystemDownException.ErrorCodeEnum;
import gov.va.med.mhv.usermgmt.service.UserMgmtService;

import java.util.Map;

import javax.servlet.http.HttpSession;

import org.springframework.stereotype.Component;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.PortalSessionThreadLocal;
import com.liferay.portal.security.auth.AuthException;
import com.liferay.portal.security.auth.Authenticator;

@Component
public class MhvPostAuthenticator implements Authenticator {

	private static final Log LOG = LogFactoryUtil.getLog(MhvPostAuthenticator.class);
	private UserMgmtService userMgmtService = null ;

	@Override
	public int authenticateByScreenName(long companyId, String screenName, String password,
			Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
		
		System.out.println("############# Inside  MhvPostAuthenticator");
		
		HttpSession session = null;
		
		try {
			session = PortalSessionThreadLocal.getHttpSession();
			
			if(session.getAttribute(MhvAuthenticator.ATTR_USER_PROFILE) != null){
				UserProfileDTO userprofile=(UserProfileDTO)session.getAttribute(MhvAuthenticator.ATTR_USER_PROFILE);
				this.doPostLoginUpdateUser(userprofile.getId());
			}

		} catch (AuthException ae) {
			if(session != null && ae.getCause() instanceof SystemDownException) {
				session.setAttribute(MhvAuthenticator.ATTR_MHV_API_ERROR_CODE, ((SystemDownException)ae.getCause()).getErrorCode());
			}
			throw ae;
		} catch (Exception e) {
			LOG.error("API Server is down or User Management Web Service not available");
			LOG.error(e.getMessage());
			throw new AuthException(new SystemDownException(e));
		}
		return SUCCESS;
	}
	

	@Override
	public int authenticateByUserId(long companyId, long userId, String password, Map<String, String[]> headerMap,
			Map<String, String[]> parameterMap) throws AuthException {
		throw new AuthException("Unsupported authentication type: Authenticate by User ID.");
	}

	@Override
	public int authenticateByEmailAddress(long companyId, String emailAddress, String password,
			Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
		throw new AuthException("Unsupported authentication type: Authenticate by Email Address.");
	}
	

	private void doPostLoginUpdateUser(Long userProfileId) throws AuthException {
		try {
			getUserManagementService().postLoginUpdateUser(userProfileId);
		} catch (MHVException ex) {
			LOG.error(ErrorCodeEnum.USER_MANAGMENT_FAILURE_POST_LOGIN_UPDATE.toString(), ex);
			throw new AuthException("Error performing post login updates for User.", new SystemDownException(ErrorCodeEnum.USER_MANAGMENT_FAILURE_POST_LOGIN_UPDATE, ex));
		}
	}

	private UserMgmtService getUserManagementService() {
		if (this.userMgmtService == null) {
			this.userMgmtService = (UserMgmtService) ApplicationContextProvider.getApplicationContext()
					.getBean("userMgmtServiceProxy");
		}
		return this.userMgmtService;
	}

}
